/*
 * Decompiled with CFR 0.152.
 */
package flash.io;

import exploit.control.AppControl;
import flash.io.BitInput;
import flash.io.BitLibrary;
import flash.objects.CXFORMALPHA;
import flash.objects.FColor;
import flash.objects.FFill;
import flash.objects.FGradient;
import flash.objects.FGradientRecord;
import flash.objects.FLine;
import flash.objects.FMatrix;
import flash.objects.FMorphGradient;
import flash.objects.FMorphGradientRecord;
import flash.objects.FMorphLine;
import flash.objects.FMorphSolid;
import flash.objects.FMorphTexture;
import flash.objects.FRect;
import flash.objects.FSolid;
import flash.objects.FTexture;
import flash.tags.Tag;
import java.io.IOException;
import java.util.Vector;

public class TypeReader {
    private BitLibrary bl;
    private BitInput bi;
    private int version;
    private boolean isDebug;

    public TypeReader(BitLibrary bitLibrary, BitInput bitInput, int n) {
        this.bl = bitLibrary;
        this.bi = bitInput;
        this.version = n;
        this.isDebug = AppControl.getInfo().getDebug();
        if (this.isDebug) {
            System.out.println("Type Reader: Active");
        }
    }

    public String string() throws IOException {
        String string = "";
        int n = (int)this.bl.ui8();
        while (n != 0) {
            string = string + "" + (char)n;
            n = (int)this.bl.ui8();
        }
        return string;
    }

    public String string(int n) throws IOException {
        String string = "";
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = (int)this.bl.ui8();
            string = string + "" + (char)n2;
        }
        return string;
    }

    public FRect rect() throws IOException {
        int n = (int)this.bl.ub(5);
        return new FRect(this.bl.sb(n), this.bl.sb(n), this.bl.sb(n), this.bl.sb(n));
    }

    public Tag tag() throws IOException {
        long l = this.bl.ui16();
        int n = (int)(l >> 6);
        long l2 = l & 0x3FL;
        if (l2 == 63L) {
            l2 = this.bl.ui32();
        }
        return new Tag(n, l2);
    }

    public FLine linestyle(int n) throws IOException {
        if (n == 4) {
            int n2 = (int)this.bl.ui16();
            int n3 = (int)this.bl.ub(2);
            int n4 = (int)this.bl.ub(2);
            int n5 = (int)this.bl.ub(1);
            int n6 = (int)this.bl.ub(1);
            int n7 = (int)this.bl.ub(1);
            int n8 = (int)this.bl.ub(1);
            int n9 = (int)this.bl.ub(5);
            int n10 = (int)this.bl.ub(1);
            int n11 = (int)this.bl.ub(2);
            FColor fColor = null;
            FFill fFill = null;
            float f = 0.0f;
            if (n4 == 2) {
                f = this.bl.fb(16);
            }
            if (n5 == 1) {
                fFill = this.fillstyle(n);
            } else {
                fColor = this.rgba(n);
            }
            return new FLine(n2, n3, n4, n11, n10 == 1, n6 == 1, n7 == 1, n8 == 1, f, fFill, fColor);
        }
        return new FLine(this.bl.ui16(), this.rgba(n));
    }

    public Vector gradient(int n) throws IOException {
        int n2 = (int)this.bl.ui8();
        Vector<FGradientRecord> vector = new Vector<FGradientRecord>(n2);
        for (int i = 0; i < n2; ++i) {
            vector.add(this.gradrecord(n));
        }
        return vector;
    }

    public FGradientRecord gradrecord(int n) throws IOException {
        return new FGradientRecord((int)this.bl.ui8(), this.rgba(n));
    }

    public FFill fillstyle(int n) throws IOException {
        int n2 = (int)this.bl.ui8();
        switch (n2) {
            case 0: {
                return new FSolid(this.rgba(n));
            }
            case 16: {
                return new FGradient(n, 1, this.matrix(), this.gradient(n));
            }
            case 18: {
                return new FGradient(n, 2, this.matrix(), this.gradient(n));
            }
            case 19: {
                return new FGradient(n, 5, this.matrix(), this.gradient(n));
            }
            case 64: {
                return new FTexture(3, (int)this.bl.ui16(), this.matrix());
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                return new FTexture(4, (int)this.bl.ui16(), this.matrix());
            }
        }
        return null;
    }

    public FColor rgba(int n) throws IOException {
        return new FColor((int)this.bl.ui8(), (int)this.bl.ui8(), (int)this.bl.ui8(), (int)(n < 3 ? 255L : this.bl.ui8()));
    }

    public FMatrix matrix() throws IOException {
        int n;
        FMatrix fMatrix = new FMatrix();
        this.bi.align();
        if (this.bl.ub(1) == 1L) {
            n = (int)this.bl.ub(5);
            fMatrix.setScaleX(this.bl.fb(n));
            fMatrix.setScaleY(this.bl.fb(n));
        }
        if (this.bl.ub(1) == 1L) {
            n = (int)this.bl.ub(5);
            fMatrix.setRotateSkew0(this.bl.fb(n));
            fMatrix.setRotateSkew1(this.bl.fb(n));
        }
        n = (int)this.bl.ub(5);
        fMatrix.setTranslateX(this.bl.sb(n));
        fMatrix.setTranslateY(this.bl.sb(n));
        return fMatrix;
    }

    public CXFORMALPHA cxform(boolean bl) throws IOException {
        int n;
        this.bi.align();
        boolean bl2 = false;
        boolean bl3 = false;
        bl2 = this.bl.ub(1) == 1L;
        bl3 = this.bl.ub(1) == 1L;
        CXFORMALPHA cXFORMALPHA = new CXFORMALPHA(bl2, bl3, bl);
        int n2 = (int)this.bl.ub(4);
        if (bl3) {
            for (n = 0; n < (bl ? 4 : 3); ++n) {
                cXFORMALPHA.setMulti(n, (int)this.bl.sb(n2));
            }
        }
        if (bl2) {
            for (n = 0; n < (bl ? 4 : 3); ++n) {
                cXFORMALPHA.setAdd(n + 4, (int)this.bl.sb(n2));
            }
        }
        return cXFORMALPHA;
    }

    public FFill morphFillStyle() throws IOException {
        int n = (int)this.bl.ui8();
        switch (n) {
            case 0: {
                return new FMorphSolid(this.rgba(3), this.rgba(3));
            }
            case 16: {
                return new FMorphGradient(1, this.matrix(), this.matrix(), this.morphGradient());
            }
            case 18: {
                return new FMorphGradient(2, this.matrix(), this.matrix(), this.morphGradient());
            }
            case 65: {
                return new FMorphTexture((int)this.bl.ui16(), this.matrix(), this.matrix());
            }
        }
        return null;
    }

    public FMorphLine morphLineStyle() throws IOException {
        return new FMorphLine(this.bl.ui16(), this.bl.ui16(), this.rgba(3), this.rgba(3));
    }

    public Vector morphGradient() throws IOException {
        int n = (int)this.bl.ui8();
        Vector<FMorphGradientRecord> vector = new Vector<FMorphGradientRecord>(n);
        for (int i = 0; i < n; ++i) {
            vector.add(this.morphGradRecord());
        }
        return vector;
    }

    public FMorphGradientRecord morphGradRecord() throws IOException {
        return new FMorphGradientRecord((int)this.bl.ui8(), this.rgba(3), (int)this.bl.ui8(), this.rgba(3));
    }
}

